class Tower_LaserCannon extends Tower;

var Actor MuzzFlash;
var float Range;
var Pawn Target;

simulated function Tick(float DT) 
{
	Super.Tick(DT);
	
	if ( Target != None )
		{
		//DesiredRotation = Rotator( (Target.Location - Vect(0,0,30)) - Location);
		Focus = Target.Location - Vect(0,0,30);
		}
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function Timer()
	{
	CalculateTowerSellValue();
	if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).LaserCannonLevel == 1 )
		{
		SetTimer(0.5,True);
		Range = 300;
		}
	else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).LaserCannonLevel == 2 )
		{
		SetTimer(0.4,True);
		Range = 350;
		}
	else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).LaserCannonLevel == 3 )
		{
		SetTimer(0.3,True);
		Range = 400;
		}
	else
		{
		SetTimer(0.6,True);
		Range = 250;
		}
	FireAtEnemy();
	}

	function FireAtEnemy()
	{
	local Pawn P;
	local float ClosestOne,ClosestTwo;
	
	Target = None;
	
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
		if ( P.IsA('Balloon') )
			{
			if ( Balloon(P).bCamo && !PBPRI(TowerOwner.PlayerReplicationInfo).bHasCamoDetection)
				{
				//Player doesn't have camo detection na na na naaaaa naaaa :-P
				}
			else
				{
				if ( Vsize(P.Location - Location) < Range )
					{
					if ( Vsize(P.Location - Location) < ClosestOne || ClosestOne == 0 )
						{
						ClosestOne = Vsize(P.Location - Location);
						Target = P;
						}
					}
				}
			}
		}
	if ( Target != None )
		{
		Shoot(Target);
		Enemy = Target;
		MyTarget = Target;
		}
	else
		MyTarget = None;
	}

	function Shoot(Pawn Target)
	{
	local Actor HitActor;
	local Vector HitLocation, HitNormal, EndTrace, ProjStart, X,Y,Z;
	local rotator ShootRot;
	local LaserTracer LT;
	
	PlaySound(FireSound, SLOT_None,5.0);
	GetAxes(Rotation,X,Y,Z);
	ProjStart = Location + X*39 + 5 * Y + 39 * Z;
	ShootRot = rotator(Enemy.Location - ProjStart);
	GetAxes(ShootRot,X,Y,Z);
	//PlayAnim(PickAnim());
	LT = Spawn(class'LaserTracer',,, ProjStart, ShootRot);
	LT.MultiSkins[1] = Texture'LavaFX.lava5';
	LT.bMeshEnviroMap = True;
	HitActor = TraceShot(HitLocation,HitNormal,ProjStart + 10000 * X,ProjStart);
	ProcessTraceHit(HitActor, HitLocation, HitNormal, X,Y,Z);
	//DesiredRotation.Pitch = 3200;
	}
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
        
	if (Other == Level) 
		Spawn(class'UT_LightWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( Other.IsA('Balloon') ) 
		{
		Other.TakeDamage(2, TowerOwner, HitLocation, 2*50.0*X, 'Tower');
		}
}

function Name PickAnim()
{
/*
	if (DesiredRotation.Pitch < -1000 )
	{
		if ( DesiredRotation.Pitch < -4000 )
			return 'Fire5';
		else 
			return 'Fire3';
	}
	else if (DesiredRotation.Pitch > 1000 ) 
	{
		if ( DesiredRotation.Pitch > 4000 )
			return 'Fire9';
		else 
			return 'Fire7';
	}
	else 
		return 'Fire1';
*/
}

defaultproperties
{
	 TowerName="Laser Cannon Tower"
	 ProjectileType=Class'Proj_Tower_Krall'
	 FireSound=Sound'UnrealI.Cannon.CannonShot'
	 TimerSpeed(1)=1.2
	 TimerSpeed(2)=1.2
	 TimerSpeed(3)=1.2
	 TimerSpeed(4)=1.2
     DrawType=DT_Mesh
     Mesh=LodMesh'Botpack.grmockgunM'
     TransientSoundVolume=1.500000
     CollisionRadius=25.000000
     CollisionHeight=46.000000
	 DrawScale=0.6
	 Rotation=(Pitch=3200,Yaw=0,Roll=0)
}
